program dotNetApp;

uses
  Borland.Win32.Windows,
  System.Runtime.InteropServices,
  System.Text,
  System.Windows.Forms;

type
  TfrmPInvoke = class(Form)
    btnUserName: Button;
    btnComputerName: Button;
    btnWindowsDir: Button;
    btnSystemDir: Button;
    btnCurrentDir: Button;
    procedure btnUserNameClick(Sender: TObject; Args: EventArgs);
    procedure btnComputerNameClick(Sender: TObject; Args: EventArgs);
    procedure btnWindowsDirClick(Sender: TObject; Args: EventArgs);
    procedure btnSystemDirClick(Sender: TObject; Args: EventArgs);
    procedure btnCurrentDirClick(Sender: TObject; Args: EventArgs);
  public
    constructor Create;
  end;

{ TfrmPInvoke }

constructor TfrmPInvoke.Create;
begin
  inherited;
  Width := 776;
  Height := 90;
  StartPosition := FormStartPosition.CenterScreen;
  Text := '.NET App Using Win32 String Routines';
  FormBorderStyle := FormBorderStyle.FixedSingle;
  MinimizeBox := False;
  MaximizeBox := False;
  btnUserName := Button.Create;
  with btnUserName do
  begin
    Text := 'User Name';
    SetBounds(16, 16, 137, 33);
    Parent := Self;
    Add_Click(btnUserNameClick);
  end;
  btnComputerName := Button.Create;
  with btnComputerName do
  begin
    Text := 'Computer Name';
    SetBounds(168, 16, 137, 33);
    Parent := Self;
    Add_Click(btnComputerNameClick);
  end;
  btnWindowsDir := Button.Create;
  with btnWindowsDir do
  begin
    Text := 'Windows Dir';
    SetBounds(320, 16, 137, 33);
    Parent := Self;
    Add_Click(btnWindowsDirClick);
  end;
  btnSystemDir := Button.Create;
  with btnSystemDir do
  begin
    Text := 'System Dir';
    SetBounds(472, 16, 137, 33);
    Parent := Self;
    Add_Click(btnSystemDirClick);
  end;
  btnCurrentDir := Button.Create;
  with btnCurrentDir do
  begin
    Text := 'Current Dir';
    SetBounds(624, 16, 137, 33);
    Parent := Self;
    Add_Click(btnCurrentDirClick);
  end;
end;

function SysErrorMessage(ErrorCode: Integer): string;
var
  Msg: StringBuilder;
begin
  Msg := StringBuilder.Create(1024);
  if FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, nil, ErrorCode, 0, Msg,
                   Msg.Capacity, nil) <> 0 then
    Result := Msg.ToString
  else
    Result := 'Unrecognised error'
end;

type
  EWin32Error = class(Exception)
  public
    ErrorCode: Integer;
  end;

procedure RaiseLastWin32Error;
var
  LastError: Integer;
begin
  //LastError := Borland.Delphi.System.GetLastError;
  LastError := Marshal.GetLastWin32Error;
  if LastError <> 0 then
    raise EWin32Error.Create(
      Format('System Error.  Code: %d.'#13'%s',
        [LastError, SysErrorMessage(LastError)]))
  else
    raise EWin32Error.Create('A call to a Win32 function failed')
end;

function Win32Check(RetVal: Bool): Bool;
begin
  if not RetVal then
    RaiseLastWin32Error;
  Result := RetVal;
end;

procedure TfrmPInvoke.btnUserNameClick(Sender: TObject; Args: EventArgs);
var
  UserBuf: StringBuilder;
  UserBufLen: LongWord;
begin
  UserBuf := StringBuilder.Create(2);
  UserBufLen := UserBuf.Capacity;
  Win32Check(GetUserName(UserBuf, UserBufLen));
  MessageBox.Show(UserBuf.ToString)
end;

procedure TfrmPInvoke.btnComputerNameClick(Sender: TObject; Args: EventArgs);
var
  ComputerBuf: StringBuilder;
  ComputerBufLen: LongWord;
begin
  //Set max size buffer to ensure success
  ComputerBuf := StringBuilder.Create(MAX_COMPUTERNAME_LENGTH);
  ComputerBufLen := ComputerBuf.Capacity;
  Win32Check(GetComputerName(ComputerBuf, ComputerBufLen));
  MessageBox.Show(ComputerBuf.ToString)
end;

procedure TfrmPInvoke.btnWindowsDirClick(Sender: TObject; Args: EventArgs);
var
  WinDirBuf: StringBuilder;
begin
  WinDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetWindowsDirectory(WinDirBuf, WinDirBuf.Capacity)));
  MessageBox.Show(WinDirBuf.ToString)
end;

procedure TfrmPInvoke.btnSystemDirClick(Sender: TObject; Args: EventArgs);
var
  SysDirBuf: StringBuilder;
begin
  SysDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetSystemDirectory(SysDirBuf, SysDirBuf.Capacity)));
  MessageBox.Show(SysDirBuf.ToString)
end;

procedure TfrmPInvoke.btnCurrentDirClick(Sender: TObject; Args: EventArgs);
var
  CurrDirBuf: StringBuilder;
begin
  CurrDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetCurrentDirectory(CurrDirBuf.Capacity, CurrDirBuf)));
  MessageBox.Show(CurrDirBuf.ToString)
end;

begin
  Application.Run(TfrmPInvoke.Create);
end.
